#include <stdio.h>
#include <string.h>
#include <float.h>
#include <vector>
#include "QdFtdcMdApi.h"

using namespace std;


class CSimpleHandler : public CQdFtdcMduserSpi
{
public:
	CSimpleHandler(CQdFtdcMduserApi *pUserApi) : m_pUserApi(pUserApi) {
		
	}

	~CSimpleHandler() {}

	
	// ͻ鷢ͨӣͻҪе¼
	void OnFrontConnected()
	{
		printf("OnFrontConnected.\n");
		CQdFtdcReqUserLoginField reqUserLogin;
		strcpy(reqUserLogin.TradingDay, m_pUserApi->GetTradingDay());
		strcpy(reqUserLogin.BrokerID, "0001");
		strcpy(reqUserLogin.UserID, "t002");
		strcpy(reqUserLogin.Password, "111111");
		m_pUserApi->ReqUserLogin(&reqUserLogin, 0);
	}

	// ͻ鷢ͨӶϿʱ÷
	void OnFrontDisconnected()
	{
		// APIԶӣͻ˿ɲ
		printf("OnFrontDisconnected.\n");
	}

	// ͻ˷¼֮󣬸÷ᱻã֪ͨͻ˵¼Ƿɹ
	void OnRspUserLogin(CQdFtdcRspUserLoginField *pRspUserLogin, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
	{
		//printf("OnRspUserLogin:\n");
		//printf("ErrorCode=[%d], ErrorMsg=[%s]\n", pRspInfo->ErrorID, pRspInfo->ErrorMsg);
		//printf("RequestID=[%d], Chain=[%d]\n", nRequestID, bIsLast);

		if (pRspInfo->ErrorID != 0)
		{
			// ˵ʧܣͻд
			printf("Failed to login, errorcode=%d errormsg=%s requestid=%d chain=%d", pRspInfo->ErrorID, pRspInfo->ErrorMsg, nRequestID, bIsLast);
			return;
		}
		printf("Login Success.\n");
		//tcp api
		char * contracts[1] = { 0 };
		contracts[0] = "i2102-C-460";


		//עҪĺԼ
		m_pUserApi->SubMarketData(contracts,1);	
		//ȡҪĺԼ
		//m_pUserApi->UnSubMarketData(contracts,1);
	}

	// ֪֪ͨͨͻ
	void OnRtnDepthMarketData(CQdFtdcDepthMarketDataField *pMarketData)
	{
		//if(!strcmp(pMarketData->InstrumentID,"000826"))
		//if(!strcmp(pMarketData->ExchangeID, "SZSE"))
		{
			printf("InstrumentID=[%s],Vm=[%d],updateTime=[%s],openPrice=[%f]\n", pMarketData->InstrumentID,pMarketData->Volume,pMarketData->UpdateTime,pMarketData->OpenPrice);
			printf("AskVolume1=[%d], AskVolume2=[%d], AskVolume3=[%d], AskVolume4=[%d], AskVolume5=[%d]\nBidVolume1=[%d], BidVolume2=[%d], BidVolume3=[%d], BidVolume4=[%d], BidVolume5=[%d]\n", pMarketData->AskVolume1,pMarketData->AskVolume2,pMarketData->AskVolume3,pMarketData->AskVolume4,pMarketData->AskVolume5,
                                pMarketData->BidVolume1,pMarketData->BidVolume2,pMarketData->BidVolume3,pMarketData->BidVolume4,pMarketData->BidVolume5);

		}
	}

	// ûĳ֪ͨ
	void OnRspError(CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
	{
		printf("OnRspError:\n");
		printf("ErrorCode=[%d], ErrorMsg=[%s]\n", pRspInfo->ErrorID, pRspInfo->ErrorMsg);
		printf("RequestID=[%d], Chain=[%d]\n", nRequestID, bIsLast);
		// ͻд
	}

	///ĺԼϢ
	void OnRspSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
	{
		printf("Sub ضĺԼ%s \n",pSpecificInstrument->InstrumentID);
	}

	///ĺԼϢ
	void OnRspUnSubMarketData(CQdFtdcSpecificInstrumentField *pSpecificInstrument, CQdFtdcRspInfoField *pRspInfo, int nRequestID, bool bIsLast)
	{
		//printf("UnSub ضĺԼ%s \n",pSpecificInstrument->InstrumentID);
	}

private:
	// ָCQdFtdcMduserApiʵָ
	CQdFtdcMduserApi *m_pUserApi;
};

int main()
{

	CQdFtdcMduserApi *pUserApi = CQdFtdcMduserApi::CreateFtdcMduserApi();
	// һ¼ʵ
	CSimpleHandler *sh = new CSimpleHandler(pUserApi);
	// עһ¼ʵ
	pUserApi->RegisterSpi(sh);

	pUserApi->RegisterFront("tcp://192.168.100.175:30007");

	//APIʼ
	pUserApi->Init();

	pUserApi->Join();
	pUserApi->Release();
	return 0;
}
